// Ako hocemo da nasa objekte neke nase klase dodajemo u prioritetni red. Ta klasa mora da implementira interfejs Comparable.
class Test implements Comparable<Test> {
   private int priority; // prioriret
   public int x,y; // vrijednosti
   
   // konstruktori
   public Test(int priority) {
      this.priority = priority;
      x = 0; 
      y = 0;
   }
   
   public Test(int priority, int xx, int yy) {
	      this.priority = priority;
	      x = xx; 
	      y = yy;
   }
   
   /* Funkcija iz interfejsa Comparable. Koristi se za definisanje relacije poretka nad objektima date klase. 
	 * Potrebno je implementirati jer je funkcija za dodavanje elemenata u prioritetni red koristi.
	 * Treba da vrati negativan broj ako objekat this ima veci prioritet od objekta a, 0 ako su objekti jednakog prioriteta, a pozitivan broj inace.*/		
   public int compareTo(Test o) {
      if (this.priority < o.priority)
         return -1;
      else if (this.priority > o.priority)
         return 1;
      return 0;
   }
 
   public int getPriority() {
      return this.priority;
   }
}